-- BA Pack 3 [Trinity]
-- Character Voice Tables

-- ================================================================
-- Example
-- ================================================================
-- local VT_CHARNAME = {
--   [CHAR_SOUND_OKEY_DOKEY] = 'CharStartGame.ogg',                                       -- Starting game
--   [CHAR_SOUND_LETS_A_GO] = 'CharStartLevel.ogg',                                       -- Starting level
--   [CHAR_SOUND_GAME_OVER] = 'CharGameOver.ogg',                                         -- Game Overed
--   [CHAR_SOUND_PUNCH_YAH] = 'CharPunch1.ogg',                                           -- Punch 1
--   [CHAR_SOUND_PUNCH_WAH] = 'CharPunch2.ogg',                                           -- Punch 2
--   [CHAR_SOUND_PUNCH_HOO] = 'CharPunch3.ogg',                                           -- Punch 3
--   [CHAR_SOUND_YAH_WAH_HOO] = { 'CharJump1.ogg', 'CharJump2.ogg', 'CharJump3.ogg' },    -- First Jump Sounds
--   [CHAR_SOUND_HOOHOO] = 'CharDoubleJump.ogg',                                          -- Second jump sound
--   [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'CharTripleJump1.ogg', 'CharTripleJump2.ogg' },   -- Triple jump sounds
--   [CHAR_SOUND_UH] = 'CharBonk.ogg',                                                    -- Soft wall bonk
--   [CHAR_SOUND_UH2] = 'CharLedgeGetUp.ogg',                                             -- Quick ledge get up
--   [CHAR_SOUND_UH2_2] = 'CharLongJumpLand.ogg',                                         -- Landing after long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Hard wall bonk
--   [CHAR_SOUND_OOOF] = 'CharBonk.ogg',                                                  -- Attacked in air
--   [CHAR_SOUND_OOOF2] = 'CharBonk.ogg',                                                 -- Land from hard bonk
--   [CHAR_SOUND_HAHA] = 'CharTripleJumpLand.ogg',                                        -- Landing triple jump
--   [CHAR_SOUND_HAHA_2] = 'CharWaterLanding.ogg',                                        -- Landing in water from big fall
--   [CHAR_SOUND_YAHOO] = 'CharLongJump.ogg',                                             -- Long jump
--   [CHAR_SOUND_DOH] = 'CharBonk.ogg',                                                   -- Long jump wall bonk
--   [CHAR_SOUND_WHOA] = 'CharGrabLedge.ogg',                                             -- Grabbing ledge
--   [CHAR_SOUND_EEUH] = 'CharClimbLedge.ogg',                                            -- Climbing over ledge
--   [CHAR_SOUND_WAAAOOOW] = 'CharFalling.ogg',                                           -- Falling a long distance
--   [CHAR_SOUND_TWIRL_BOUNCE] = 'CharFlowerBounce.ogg',                                  -- Bouncing off of a flower spring
--   [CHAR_SOUND_GROUND_POUND_WAH] = 'CharGroundPound.ogg',                               -- Ground Pound after startup
--   [CHAR_SOUND_WAH2] = 'CharThrow.ogg',                                                 -- Throwing something
--   [CHAR_SOUND_HRMM] = 'CharLift.ogg',                                                  -- Lifting something
--   [CHAR_SOUND_HERE_WE_GO] = 'CharGetStar.ogg',                                         -- Star get
--   [CHAR_SOUND_SO_LONGA_BOWSER] = 'CharThrowBowser.ogg',                                -- Throwing Bowser
--   --DAMAGE
--   [CHAR_SOUND_ATTACKED] = 'CharDamaged.ogg',                                           -- Damaged
--   [CHAR_SOUND_PANTING] = 'CharPanting.ogg',                                            -- Low health
--   [CHAR_SOUND_PANTING_COLD] = 'CharPanting.ogg',                                       -- Getting cold
--   [CHAR_SOUND_ON_FIRE] = 'CharBurned.ogg',                                             -- Burned
--   --SLEEP SOUNDS
--   [CHAR_SOUND_IMA_TIRED] = 'CharTired.ogg',                                            -- Mario feeling tired
--   [CHAR_SOUND_YAWNING] = 'CharYawn.ogg',                                               -- Mario yawning before he sits down to sleep
--   [CHAR_SOUND_SNORING1] = 'CharSnore.ogg',                                             -- Snore Inhale
--   [CHAR_SOUND_SNORING2] = 'CharExhale.ogg',                                            -- Exhale
--   [CHAR_SOUND_SNORING3] = 'CharSleepTalk.ogg',                                         -- Sleep talking / mumbling
--   --COUGHING (USED IN THE GAS MAZE)
--   [CHAR_SOUND_COUGHING1] = 'CharCough1.ogg',                                           -- Cough take 1
--   [CHAR_SOUND_COUGHING2] = 'CharCough2.ogg',                                           -- Cough take 2
--   [CHAR_SOUND_COUGHING3] = 'CharCough3.ogg',                                           -- Cough take 3
--   --DEATH
--   [CHAR_SOUND_DYING] = 'CharDying.ogg',                                                -- Dying from damage
--   [CHAR_SOUND_DROWNING] = 'CharDrowning.ogg',                                          -- Running out of air underwater
--   [CHAR_SOUND_MAMA_MIA] = 'CharLeaveLevel.ogg'                                         -- Booted out of level
-- }

-- ================================================================
-- NPC Voices
-- Files are in Main
-- ================================================================

VT_NOVOICE = {
  [CHAR_SOUND_ATTACKED] = { 'sfx_smrpg_hit1.mp3', 'sfx_smrpg_shell.mp3', 'sfx_smw_bossstun.mp3', 'sfx_ff6_fistattack.mp3', 'sfx_smw_bossstun.mp3', 'sfx_mmx_hurt.mp3' },
  [CHAR_SOUND_DOH] = 'sfx_ml_bump.mp3',                                              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3', 'sfx_cv3_dead.mp3', 'sfx_earthbound_dead.mp3'},
  [CHAR_SOUND_HERE_WE_GO] = { 'sfx_alttp_item.mp3', 'sfx_smrpg_specialflower.mp3', 'sfx_earthbound_good.mp3', 'sfx_kirby_1up.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_LETS_A_GO] = { 'sfx_smb3_levelselect.mp3', 'sfx_sf2_stageselect.mp3' },                           -- Level Select
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                      -- Object Pick-up
  [CHAR_SOUND_HOOHOO] = { 'sfx_smw_jump.mp3' },                                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sfx_pm64_what.mp3',                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'sfx_smrpg_drop.mp3',                                         -- Landing After a Bonk + Thrown out of level + Also Bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'sfx_ssb64_atk3.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                     -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                       -- Bowser Throw
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3' },                                 -- Throw Object
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                           -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                   -- Falling
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                              -- Boing
  [CHAR_SOUND_WHOA] = 'sfx_ssb64_ledge.mp3',                                         -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sfx_ssb64_superjump.mp3' },                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sfx_ssb64_superjump.mp3' },                    -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },                                 -- 1st Jump(s)
}

-- ================================================================
-- Voice Tables
-- ================================================================
-- ================
-- Trinity Start
-- ================

VT_MARI = {
  [CHAR_SOUND_ATTACKED] = { 'mari_hurt5.mp3', 'mari_hurt3.mp3', 'mari_hurt2.mp3' },
  [CHAR_SOUND_DOH] = 'mari_ah.mp3',               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'mari_dead.mp3' },
  [CHAR_SOUND_EEUH] = { 'mari_ledgegetup.mp3', }, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  --[CHAR_SOUND_GROUND_POUND_WAH] = {'silent.mp3'},
  [CHAR_SOUND_HAHA] = 'mari_laugh.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'mari_subarashi.mp3', 'mari_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'mari_attack6.mp3',            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'mari_pickup.mp3',               -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'mari_pant.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'mari_levelselect.mp3',     -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = 'silent.mp3', -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'mari_hurt1.mp3', },        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'mari_ah.mp3',
  [CHAR_SOUND_OOOF2] = 'mari_hurt4.mp3',               -- Landing After a Bonk + Thrown out of level
  --[CHAR_SOUND_PANTING] = {'silent.mp3',}, -- Low Health
  --[CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'mari_attack5.mp3', }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'mari_attack6.mp3',      --2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'mari_attack7.mp3',      -- 1st Punch
  --[CHAR_SOUND_SNORING1] = 'silent.mp3',
  --[CHAR_SOUND_SNORING2] = 'silent.mp3',
  --[CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'mari_rip.mp3' },                                             --Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'mari_laugh.mp3' },                                              -- Boing
  [CHAR_SOUND_UH] = 'mari_hawah.mp3',                                                              --Drop off of ledge
  [CHAR_SOUND_UH2] = { 'mari_attack6.mp3', },                                                    -- Quick Ledge Get-Up
  [CHAR_SOUND_UH2_2] = 'mari_attack9.mp3',                                                       -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'mari_falling.mp3', -- Falling
  [CHAR_SOUND_WAH2] = 'mari_attack5.mp3',                                                        -- Throw Object
  [CHAR_SOUND_WHOA] = 'mari_uh1.mp3',                                                            -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'mari_attack3.mp3', },                                                  -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'mari_attack3.mp3', 'mari_jump1.mp3'},                                      -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'mari_attack1.mp3', 'mari_attack7.mp3', 'mari_attack8.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = 'silent.mp3',
}

VT_KAZUSA = {
  [CHAR_SOUND_ATTACKED] = { 'kazusa_dmg1.mp3', 'kazusa_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'kazusa_what.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'kazusa_dead.mp3' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'kazusa_groundpound.mp3' },
  --[CHAR_SOUND_HAHA] = nil, -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'kazusa_sugoi.mp3', 'kazusa_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'kazusa_jump4.mp3',                             -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'kazusa_pickup.mp3',                              -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'kazusa_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = 'kazusa_levelselect.mp3',                    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'kazusa_levelexit.mp3',                       -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'kazusa_what.mp3' },                         -- Touch Fire
  [CHAR_SOUND_OOOF] = 'kazusa_eh1.mp3',                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'kazusa_dmg2.mp3',                               -- Landing After a Bonk + Thrown out of level
  --[CHAR_SOUND_PANTING] = nil, -- Low Health
  --[CHAR_SOUND_PANTING_COLD] = nil,
  --[CHAR_SOUND_PRESS_START_TO_PLAY] = nil,
  [CHAR_SOUND_PUNCH_HOO] = { 'kazusa_ora.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'kazusa_atk4.mp3',    -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'kazusa_atk1.mp3',    -- 1st Punch
  --[CHAR_SOUND_SNORING1] = nil,
  --[CHAR_SOUND_SNORING2] = nil,
  --[CHAR_SOUND_SNORING3] = nil,
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'kazusa_bowserthrow.mp3' },       -- Bowser Throw
  --[CHAR_SOUND_TWIRL_BOUNCE] = nil, -- Boing
  [CHAR_SOUND_UH] = 'kazusa_eh2.mp3',                                -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'kazusa_jump2.mp3' },                         -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = { 'kazusa_fall.mp3', 'kazusa_fall2.mp3' }, -- Falling
  [CHAR_SOUND_WAH2] = 'kazusa_ora.mp3',                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'kazusa_wah2.mp3',                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'kazusa_jump3.mp3' },                       -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'kazusa_jump3.mp3' },           -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = {
    'kazusa_jump1.mp3', 'kazusa_jump5.mp3', 'kazusa_jump2.mp3'
  }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_AZUSA = {
  [CHAR_SOUND_ATTACKED] = { 'azusa_dmg3.mp3', 'azusa_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'azusa_eh1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'azusa_dead1.mp3', 'azusa_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {'nil',}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'nil'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'azusa_atk3.mp3' },
  [CHAR_SOUND_HAHA] = 'azusa_grab.mp3', -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'hiyori_really.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'nil',
  [CHAR_SOUND_HERE_WE_GO] = { 'azusa_starget1.mp3', 'azusa_vanitas2.mp3' }, -- Star Get + Obtaining Power-up + Bowser Throw when not full speed
  [CHAR_SOUND_HOOHOO] = 'azusa_atk5.mp3',                                   -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'azusa_grab.mp3',                                     -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'nil',
  [CHAR_SOUND_LETS_A_GO] = { 'azusa_ls1.mp3', 'azusa_vanitas3.mp3' },       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'azusa_getup.mp3',                                -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'azusa_dmg4.mp3' },                              -- Touch Fire
  [CHAR_SOUND_OOOF] = 'azusa_ah1.mp3',                                      -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'azusa_dmg5.mp3',                                    -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'nil',}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'nil',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'nil', 'nil'},
  [CHAR_SOUND_PUNCH_HOO] = { 'azusa_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'azusa_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'azusa_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'nil',
  -- [CHAR_SOUND_SNORING2] = 'nil',
  -- [CHAR_SOUND_SNORING3] = {'nil', 'nil'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'azusa_bowserthrow1.mp3' },                        -- Bowser Throw
  -- [CHAR_SOUND_TWIRL_BOUNCE] = {'nil'}, -- Boing
  [CHAR_SOUND_UH] = 'azusa_ah2.mp3',                                                  -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'azusa_atk6.mp3' },                                            -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'nil', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = { 'azusa_falling1.mp3' },                                   -- Falling
  [CHAR_SOUND_WAH2] = 'azusa_throw.mp3',                                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'azusa_are1.mp3',                                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'azusa_vanitas1.mp3' },                                      -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'azusa_atk3.mp3' },                              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'azusa_atk4.mp3', 'azusa_atk5.mp3', 'azusa_atk1.mp3' } -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = 'nil',
}

VT_NATSU = {
  [CHAR_SOUND_ATTACKED] = { 'natsu_dmg1.mp3', 'natsu_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'natsu_are1.mp3',           -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'natsu_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'natsu_slowclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'natsu_atk3.mp3' },
  [CHAR_SOUND_HAHA] = { 'natsu_sugoi.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'natsu_star1.mp3', 'natsu_star2.mp3', 'natsu_star3.mp3', 'natsu_star4.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'natsu_jump2.mp3' },                                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'natsu_grab.mp3',                                                                     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'natsu_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'natsu_ls1.mp3', 'natsu_ls2.mp3' },                                            -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'natsu_getup.mp3' },                                                            -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'natsu_dmg3.mp3' },                                                              -- Touch Fire
  [CHAR_SOUND_OOOF] = 'natsu_hm1.mp3',                                                                      -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'natsu_dmg2.mp3',                                                                    -- Landing After a Bonk + Thrown out of level
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'natsu_atk3.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'natsu_atk2.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'natsu_atk1.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'natsu_bthrow1.mp3' },             -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'natsu_sugoi.mp3' },                  -- Boing
  [CHAR_SOUND_UH] = 'natsu_dmg1.mp3',                                 -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'natsu_atk2.mp3' },                            -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'natsu_falling.mp3',                        -- Falling
  [CHAR_SOUND_WAH2] = { 'natsu_bthrow1.mp3' },                        -- Throw Object
  [CHAR_SOUND_WHOA] = 'natsu_are1.mp3',                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'natsu_atk4.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'natsu_atk4.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'natsu_jump1.mp3', 'natsu_atk1.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'silent.mp3'},
}

VT_MINE = {
  [CHAR_SOUND_ATTACKED] = { 'mine_dmg1.mp3', 'mine_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'mine_ah1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'mine_dead1.mp3', 'mine_dead2.mp3' },
  -- [CHAR_SOUND_EEUH] = {'mmr_slowclimb.mp3'}, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ksm_bagon.mp3'},
  -- [CHAR_SOUND_HAHA] = {'mmr_laugh1.mp3'}, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'mine_star1.mp3', 'mine_star2.mp3', 'mine_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'mine_atk1.mp3' },                                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                       -- Object Pick-up
  -- [CHAR_SOUND_IMA_TIRED] = 'ksm_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'mine_ls1.mp3' },                                        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'mine_getup1.mp3', 'mine_getup2.mp3' },                   -- Getting up after thrown out of level
  -- [CHAR_SOUND_ON_FIRE] = {'mmr_dmg1.mp3'}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'mine_ah1.mp3',                                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'mine_dmg1.mp3',                                               -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'mine_atk2.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'mine_atk1.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'mine_atk3.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'mine_bthrow1.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },  -- Boing
  -- [CHAR_SOUND_UH] = 'mmr_ah2.mp3', -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'mine_atk3.mp3' },                -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  -- [CHAR_SOUND_WAAAOOOW] = '.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'mine_atk1.mp3' },              -- Throw Object
  -- [CHAR_SOUND_WHOA] = 'mmr_ah1.mp3', -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'mine_atk4.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'mine_atk4.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'mine_jump1.mp3' },      -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'mmr_yawn.mp3'},
}

VT_TSURUGI = {
  [CHAR_SOUND_ATTACKED] = { 'tsurugi_dmg1.mp3', 'tsurugi_dmg2.mp3', 'tsurugi_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'tsurugi_dmg2.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'tsurugi_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'tsurugi_eh.mp3',  -- Object Pick-up
  -- [CHAR_SOUND_EEUH] = {'mmr_slowclimb.mp3'}, -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'tsurugi_groundPound.mp3' },
  [CHAR_SOUND_HAHA] = { 'tsurugi_laugh.mp3' },              -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = { 'tsurugi_laugh.mp3' },
  [CHAR_SOUND_HERE_WE_GO] = { 'tsurugi_star.mp3' },         -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'tsurugi_jump2.mp3' },            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_IMA_TIRED] = 'tsurugi_sleepy.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'tsurugi_letsGo.mp3' },        -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'tsurugi_levelFail.mp3' },      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'tsurugi_burn.mp3' },            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'tsurugi_dmg3.mp3',                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'tsurugi_dmg3.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'tsurugi_kick.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'tsurugi_punch2.mp3',            -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'tsurugi_punch1.mp3',            -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'tsurugi_bowser.mp3' },  -- Bowser Throw
  [CHAR_SOUND_UH] = 'tsurugi_eh.mp3',                       -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'tsurugi_atk3.mp3'}, -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'tsurugi_burn.mp3',               -- Falling
  [CHAR_SOUND_WHOA] = 'tsurugi_ledge.mp3',                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'tsurugi_yahoo.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'tsurugi_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'tsurugi_jump1.mp3' },       -- 1st Jump(s)
}

VT_ICHIKA = {
  [CHAR_SOUND_ATTACKED] = { 'ichika_dmg2.mp3', 'ichika_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'ichika_oh1.mp3',             -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ichika_dying.mp3' },
  [CHAR_SOUND_EEUH] = { 'ichika_ledgeclimb.mp3' }, -- Slow Get up from ledge
  -- [CHAR_SOUND_GAME_OVER] = {'silent.mp3'},
  -- [CHAR_SOUND_GROUND_POUND_WAH] = {'ichika_atk1.mp3'},
  [CHAR_SOUND_HAHA] = { 'ichika_jajan.mp3' }, -- Landing after backflip
  -- [CHAR_SOUND_HAHA_2] = 'silent.mp3', -- Landing on Water after a fall
  -- [CHAR_SOUND_HELLO] = 'silent.mp3',
  [CHAR_SOUND_HERE_WE_GO] = { 'ichika_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ichika_atk1.mp3' },      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'ichika_tired.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'ichika_ls1.mp3' },    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ichika_getup.mp3' },   -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = {'ichika_dmg1.mp3'}, -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ichika_woah.mp3',            -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ichika_dmg1.mp3',           -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  -- [CHAR_SOUND_PANTING] = {'silent.mp3'}, -- Low Health
  -- [CHAR_SOUND_PANTING_COLD] = 'silent.mp3',
  -- [CHAR_SOUND_PRESS_START_TO_PLAY] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_PUNCH_HOO] = { 'ichika_atk1.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ichika_atk3.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ichika_atk2.mp3',     -- 1st Punch
  -- [CHAR_SOUND_SNORING1] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING2] = 'silent.mp3',
  -- [CHAR_SOUND_SNORING3] = {'silent.mp3', 'silent.mp3'},
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ichika_bthrow.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },   -- Boing
  [CHAR_SOUND_UH] = 'ichika_oh1.mp3',                     -- Drop off of ledge + Fall off Ledge
  -- [CHAR_SOUND_UH2] = {'mine_atk3.mp3'}, -- Quick Ledge Get-Up
  -- [CHAR_SOUND_UH2_2] = 'silent.mp3', -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'ichika_shocked.mp3', -- Falling
  [CHAR_SOUND_WAH2] = { 'ichika_longjump.mp3' },          -- Throw Object
  [CHAR_SOUND_WHOA] = 'ichika_ledgegrab.mp3',                 -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ichika_longjump.mp3' },             -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ichika_yahoo.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ichika_jump1.mp3' },          -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'mmr_yawn.mp3'},
}

VT_NAGISA = {
  [CHAR_SOUND_ATTACKED] = { 'nagisa_dmg3.mp3', 'nagisa_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'nagisa_eh1.mp3',                                                    -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'nagisa_dead1.mp3', 'nagisa_dead2.mp3' },
  [CHAR_SOUND_HAHA] = { 'nagisa_laugh1.mp3' },                                            -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'nagisa_star2.mp3', 'nagisa_star1.mp3' },                   -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'nagisa_atk5.mp3' },                                            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                           -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'nagisa_atk4.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'nagisa_ls1.mp3' },                                          -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'nagisa_levelexit.mp3' },                                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'nagisa_burn.mp3' },                                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'nagisa_ara1.mp3',                                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'nagisa_dmg1.mp3',                                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'nagisa_atk3.mp3' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'nagisa_atk2.mp3',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'nagisa_atk1.mp3',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'nagisa_bthrow1.mp3' },                                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                   -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                                -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'nagisa_atk1.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                        -- Falling
  [CHAR_SOUND_WAH2] = { 'nagisa_throw1.mp3', 'nagisa_throw2.mp3' },                       -- Throw Object
  [CHAR_SOUND_WHOA] = 'nagisa_ara2.mp3',                                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'nagisa_longjump.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'nagisa_atk4.mp3', 'nagisa_longjump.mp3' },          -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'nagisa_atk1.mp3', 'nagisa_atk6.mp3', 'nagisa_atk7.mp3' }, -- 1st Jump(s)
}

VT_MIKA = {
  [CHAR_SOUND_ATTACKED] = { 'mika_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'mika_are2.mp3',                                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'mika_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'mika_laugh.mp3' },                                         -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'mika_star1.mp3', 'mika_star2.mp3' },                 -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'mika_atk5.mp3' },                                        -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                     -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'mika_atk2.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'mika_ls1.mp3' },                                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'mika_wow.mp3' },                                       -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'mika_burn.mp3' },                                       -- Touch Fire
  [CHAR_SOUND_OOOF] = 'mika_hmm.mp3',                                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'mika_dmg2.mp3',                                             -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'mika_atk2.mp3' },                                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'mika_atk3.mp3',                                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'mika_atk1.mp3',                                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'mika_useless.mp3' },                            -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                             -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                          -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'mika_atk1.mp3' },                                           -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'mika_burn.mp3',                                          -- Falling
  [CHAR_SOUND_WAH2] = { 'mika_throw.mp3' },                                         -- Throw Object
  [CHAR_SOUND_WHOA] = 'mika_are1.mp3',                                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'mika_longjump.mp3' },                                     -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'mika_longjump.mp3' },                         -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'mika_atk1.mp3', 'mika_atk3.mp3', 'mika_atk4.mp3' }, -- 1st Jump(s)
}

VT_HIFUMI = {
  [CHAR_SOUND_ATTACKED] = { 'hifumi_dmg2.mp3', 'hifumi_dmg4.mp3' },
  [CHAR_SOUND_DOH] = 'hifumi_eh1.mp3',              -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hifumi_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'hifumi_slowclimb.mp3' },   -- Slow Get up from ledge
  [CHAR_SOUND_HAHA] = { 'hifumi_ahaha.mp3' },       -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'hifumi_star1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'hifumi_atk4.mp3' },      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',     -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'hifumi_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hifumi_atk2.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'hifumi_ls.mp3' },                                           -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hifumi_levelexit.mp3' },                                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hifumi_dmg3.mp3' },                                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hifumi_are1.mp3',                                                  -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hifumi_dmg1.mp3',                                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'hifumi_atk2.mp3' },                                         -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hifumi_atk4.mp3',                                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hifumi_atk3.mp3',                                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hifumi_longjump.mp3' },                               -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                   -- Boing
  [CHAR_SOUND_UH] = 'hifumi_wah1.mp3',                                                    -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'hifumi_atk3.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'hifumi_fall.mp3',                                              -- Falling
  [CHAR_SOUND_WAH2] = { 'hifumi_atk1.mp3' },                                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'hifumi_wah2.mp3',                                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hifumi_longjump.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hifumi_atk2.mp3' },                                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hifumi_atk3.mp3', 'hifumi_atk6.mp3', 'hifumi_atk5.mp3' }, -- 1st Jump(s)
}

VT_KOHARU = {
  [CHAR_SOUND_ATTACKED] = { 'koharu_dmg4.mp3', 'koharu_dmg6.mp3' },
  [CHAR_SOUND_DOH] = 'koharu_eh1.mp3',                                  -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'koharu_dead1.mp3', 'koharu_dead2.mp3' },
  [CHAR_SOUND_HAHA] = { 'koharu_laugh.mp3' },                           -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'koharu_star1.mp3', 'koharu_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'koharu_atk4.mp3' },                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                         -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'koharu_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'koharu_atk5.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'koharu_ls1.mp3' },                              -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'koharu_deathpenalty.mp3' },                      -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'koharu_dmg3.mp3' },                               -- Touch Fire
  [CHAR_SOUND_OOOF] = 'koharu_are1.mp3',                                      -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'koharu_dmg1.mp3',                                     -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'koharu_atk5.mp3' },                             -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'koharu_atk3.mp3',                                 -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'koharu_atk1.mp3',                                 -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'koharu_bthrow.mp3' },                     -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                       -- Boing
  [CHAR_SOUND_UH] = 'koharu_are1.mp3',                                        -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'koharu_atk1.mp3' },                                   -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'koharu_fall.mp3',                                  -- Falling
  [CHAR_SOUND_WAH2] = { 'koharu_echidame.mp3' },                              -- Throw Object
  [CHAR_SOUND_WHOA] = 'koharu_eh1.mp3',                                       -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'koharu_jump2.mp3' },                                -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'koharu_jump1.mp3', 'koharu_atk6.mp3' }, -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'koharu_atk1.mp3', 'koharu_atk3.mp3' },        -- 1st Jump(s)
}

VT_HANAKO = {
  [CHAR_SOUND_ATTACKED] = { 'hanako_dmg1.mp3', 'hanako_dmg2.mp3', 'hanako_dmg5.mp3' },
  [CHAR_SOUND_DOH] = 'hanako_ah.mp3',                                                       -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hanako_dead1.mp3' },
  [CHAR_SOUND_EEUH] = { 'hanako_slowclimb.mp3' },                                           -- Slow Get up from ledge
  [CHAR_SOUND_HAHA] = { 'hanako_laugh.mp3' },                                               -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'hanako_star1.mp3', 'hanako_star2.mp3', 'hanako_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'hanako_atk2.mp3' },                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                             -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = 'kisaki_rest.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hanako_atk7.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'hanako_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hanako_begentle.mp3' },                   -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hanako_dmg6.mp3' },                        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hanako_ara1.mp3',                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hanako_ara3.mp3',                              -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'hanako_atk3.mp3' },                      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hanako_atk4.mp3',                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hanako_atk1.mp3',                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hanako_bthrow.mp3' },              -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                -- Boing
  [CHAR_SOUND_UH] = 'hanako_eh.mp3',                                   -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'hanako_atk1.mp3' },                            -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'hanako_gasp.mp3',                           -- Falling
  [CHAR_SOUND_WAH2] = { 'hanako_atk5.mp3' },                           -- Throw Object
  [CHAR_SOUND_WHOA] = 'hanako_ara2.mp3',                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hanako_atk6.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hanako_atk5.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hanako_atk1.mp3', 'hanako_atk8.mp3' }, -- 1st Jump(s)
}

VT_AIRI = {
  [CHAR_SOUND_ATTACKED] = { 'airi_ehh.mp3' },
  [CHAR_SOUND_DOH] = 'airi_eh1.mp3',                                 -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'airi_defeat1.mp3' },
  [CHAR_SOUND_HAHA] = { 'airi_laugh1.mp3' },                         -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'airi_star1.mp3', 'airi_star2.mp3' },  -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'airi_atk3.mp3' },                         -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'airi_hm1.mp3',                                -- Object Pick-up
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'airi_atk1.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'airi_ls1.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'airi_levelexit.mp3', 'airi_pout.mp3' }, -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                    -- Touch Fire
  [CHAR_SOUND_OOOF] = 'airi_ah1.mp3',                                -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'airi_dmg1.mp3',                              -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'airi_atk3.mp3' },                      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'airi_atk6.mp3',                          -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'airi_atk5.mp3',                          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'airi_bthrow.mp3' },              -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },              -- Boing
  [CHAR_SOUND_UH] = 'airi_eh2.mp3',                                  -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'airi_atk4.mp3' },                            -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'airi_fall.mp3',                           -- Falling
  [CHAR_SOUND_WAH2] = { 'airi_throw1.mp3' },                         -- Throw Object
  [CHAR_SOUND_WHOA] = 'airi_hm1.mp3',                                -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'airi_atk2.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'airi_atk2.mp3' },              -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'airi_atk5.mp3', 'airi_atk1.mp3' },   -- 1st Jump(s)
}

VT_YOSHIMI = {
  [CHAR_SOUND_ATTACKED] = { 'yosh_dmg3.mp3', 'yosh_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'yosh_ah1.mp3',                                                  -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sfx_smb3_down.mp3' },
  [CHAR_SOUND_HAHA] = { 'yosh_heh.mp3' },                                             -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'yosh_star1.mp3', 'yosh_star2.mp3', 'yosh_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'yosh_atk2.mp3' },                                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'yosh_hm2.mp3',                                                 -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'yosh_tired.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'yosh_atk6.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'yosh_ls1.mp3' },                                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'yosh_levelexit1.mp3', 'yosh_levelexit2.mp3' },         -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                   -- Touch Fire
  [CHAR_SOUND_OOOF] = 'yosh_grabbed.mp3',                                           -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'yosh_dmg3.mp3',                                             -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'yosh_atk3.mp3' },                                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'yosh_atk5.mp3',                                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'yosh_atk7.mp3',                                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'yosh_bthrow1.mp3' },                            -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                             -- Boing
  [CHAR_SOUND_UH] = 'yosh_hm2.mp3',                                                 -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'yosh_atk4.mp3' },                                           -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'yosh_fall.mp3',                                          -- Falling
  [CHAR_SOUND_WAH2] = { 'yosh_throw1.mp3' },                                        -- Throw Object
  [CHAR_SOUND_WHOA] = 'yosh_are1.mp3',                                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'yosh_atk3.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'yosh_atk3.mp3' },                             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'yosh_atk4.mp3', 'yosh_atk5.mp3', 'yosh_atk7.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'yosh_yawn.mp3' },
}

VT_HASUMI = {
  [CHAR_SOUND_ATTACKED] = { 'hasumi_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'hasumi_are1.mp3',                                -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hasumi_dying.mp3' },
  [CHAR_SOUND_HAHA] = { 'hasumi_laugh.mp3' },                          -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'hasumi_star.mp3', 'hasumi_star2.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'hasumi_jump2_1.mp3' },                      -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                        -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'hasumi_hm.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'hasumi_groundPound.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'hasumi_letsGo.mp3' },                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'hasumi_levelFail.mp3' },                     -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'hasumi_burn.mp3' },                           -- Touch Fire
  [CHAR_SOUND_OOOF] = 'hasumi_ah1.mp3',                                   -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'hasumi_dmg1.mp3',                                 -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'hasumi_punch2.mp3' },                       -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'hasumi_kick.mp3',                             -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'hasumi_kick.mp3',                             -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hasumi_bowser.mp3' },                 -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                   -- Boing
  [CHAR_SOUND_UH] = 'hasumi_ah1.mp3',                                     -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'hasumi_jump1_2.mp3' },                            -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                        -- Falling
  [CHAR_SOUND_WAH2] = { 'hasumi_punch2.mp3', 'hasumi_bowser.mp3' },       -- Throw Object
  [CHAR_SOUND_WHOA] = 'hasumi_are1.mp3',                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hasumi_yahoo.mp3' },                            -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hasumi_yahoo.mp3' },                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hasumi_kick.mp3', 'hasumi_jump1_2.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'hasumi_yawn.mp3'},
}

VT_SEIA = {
  [CHAR_SOUND_ATTACKED] = { 'seia_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'seia_dmg2.mp3',                                                 -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'seia_dead1.mp3' },
  [CHAR_SOUND_HAHA] = { 'seia_subarashi.mp3' },                                       -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'seia_star1.mp3', 'seia_star2.mp3', 'seia_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'seia_atk2.mp3' },                                          -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                                       -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'seia_hm2.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'seia_atk2.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'seia_ls1.mp3' },                                      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'seia_levelexit.mp3' },                                 -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sfx_smrpg_hot.mp3' },                                   -- Touch Fire
  [CHAR_SOUND_OOOF] = 'seia_hm1.mp3',                                               -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'seia_dmg2.mp3',                                             -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'seia_atk1.mp3' },                                     -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'seia_atk5.mp3',                                         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'seia_atk6.mp3',                                         -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'seia_useless.mp3' },                            -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                             -- Boing
  [CHAR_SOUND_UH] = 'sfx_smrpg_throw.mp3',                                          -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'seia_atk2.mp3' },                                           -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'sfx_ssb64_falling.mp3',                                  -- Falling
  [CHAR_SOUND_WAH2] = { 'sfx_ssb64_itemthrow.mp3', 'seia_kys.mp3' },                -- Throw Object
  [CHAR_SOUND_WHOA] = 'seia_hm1.mp3',                                               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'seia_atk3.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'seia_atk3.mp3', 'seia_atk1.mp3' },            -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'seia_atk1.mp3', 'seia_atk5.mp3', 'seia_atk7.mp3' }, -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'serika_yawn.mp3'},
}

VT_SUZUMI = {
  [CHAR_SOUND_ATTACKED] = { 'suzumi_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'suzumi_dmg2.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'suzumi_dead1.mp3', 'suzumi_dead2.mp3' },
  [CHAR_SOUND_HAHA] = {'suzumi_hai.ogg'}, -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'suzumi_star1.mp3', 'suzumi_star2.mp3', 'suzumi_star3.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'suzumi_atk2.mp3' },                                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'suzumi_humu.mp3',                                             -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = 'suzumi_humu.mp3',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'suzumi_atk1.mp3' },
  [CHAR_SOUND_LETS_A_GO] = { 'suzumi_ls1.mp3' },           -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'suzumi_dead3.mp3' },          -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'suzumi_sona.ogg' },          -- Touch Fire
  [CHAR_SOUND_OOOF] = 'suzumi_ah.ogg', -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'suzumi_dmg2.mp3',                  -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'suzumi_atk5.mp3' },          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'suzumi_atk2.mp3',              -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'suzumi_atk3.mp3',              -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'suzumi_bthrow1.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },    -- Boing
  [CHAR_SOUND_UH] = 'suzumi_ah.ogg',                 -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'suzumi_atk1.mp3' },                -- Quick Ledge Get-Up
  [CHAR_SOUND_EEUH] = 'suzumi_atk2.mp3', -- Slow Get up from ledge
  [CHAR_SOUND_WAAAOOOW] = 'suzumi_sona.ogg',         -- Falling
  [CHAR_SOUND_WAH2] = { 'suzumi_bthrow2.mp3' },            -- Throw Object
  [CHAR_SOUND_WHOA] = 'suzumi_humu.mp3',               -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'suzumi_atk5.mp3' },              -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'suzumi_atk5.mp3' },  -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'suzumi_atk1.mp3' },        -- 1st Jump(s)
  -- [CHAR_SOUND_YAWNING] = {'serika_yawn.mp3'},
}

VT_REISA = {
  [CHAR_SOUND_ATTACKED] = { 'reisa_dmg2.mp3', 'reisa_dmg1.mp3' },
  [CHAR_SOUND_DOH] = 'reisa_huh1.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'reisa_dead.mp3' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'reisa_bowserthrow2.mp3' },
  [CHAR_SOUND_HAHA] = 'reisa_desu.mp3', -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'reisa_starget1.mp3' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'reisa_jump1.mp3',            -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'reisa_pickup.mp3',             -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = {'reisa_levelselect.mp3', 'reisa_levelselect2.mp3'},   -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'reisa_daijobu.mp3', -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'reisa_dmg3.mp3' },        -- Touch Fire
  [CHAR_SOUND_OOOF] = 'reisa_ledgegrab.mp3',
  [CHAR_SOUND_OOOF2] = 'reisa_dmg1.mp3',              -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'reisa_atk1.mp3' }, -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'reisa_atk4.mp3',     -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'reisa_atk2.mp3',     -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = {'reisa_bowserthrow2.mp3'}, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'reisa_hisatsu.mp3' },                                   -- Boing
  [CHAR_SOUND_UH] = 'reisa_ah1.mp3',                                                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'reisa_atk7.mp3' },                                               -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'reisa_uwah.mp3', 											 -- Falling
  [CHAR_SOUND_WAH2] = {'reisa_throw.mp3', 'reisa_throw2.mp3'},                          -- Throw Object
  [CHAR_SOUND_WHOA] = 'reisa_ledgegrab.mp3',                                             -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'reisa_longjump.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'reisa_jump4.mp3' },                                -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'reisa_jump3.mp3', 'reisa_atk2.mp3', 'reisa_atk5.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_SAKURAKO = {
  [CHAR_SOUND_ATTACKED] = { 'sakurako_dmg5.mp3', 'sakurako_dmg1.mp3', 'sakurako_dmg2.mp3' },
  [CHAR_SOUND_DOH] = 'sakurako_bonk.mp3', -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'sakurako_dead1.mp3' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'sakurako_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'sakurako_heehee.mp3', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'sakurako_star2.mp3' },                        -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = 'sakurako_jump3.mp3',                                -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                              -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = nil,
  [CHAR_SOUND_LETS_A_GO] = 'sakurako_levelselect.mp3',                       -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'sakurako_levelexit.mp3',                          -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'sakurako_dmg3.mp3' },                            -- Touch Fire
  [CHAR_SOUND_OOOF] = 'sakurako_huh.mp3',
  [CHAR_SOUND_OOOF2] = 'sakurako_dmg4.mp3',                                  -- Landing After a Bonk + Thrown out of level
  [CHAR_SOUND_PUNCH_HOO] = { 'sakurako_atk1.mp3' },                          -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sakurako_atk2.mp3',                              -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sakurako_atk3.mp3',                              -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sakurako_bthrow.mp3' },                  -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                      -- Boing
  [CHAR_SOUND_UH] = 'sakurako_drop.mp3',                                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'sakurako_atk2.mp3' },                                -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'sakurako_fall.mp3',                               -- Falling
  [CHAR_SOUND_WAH2] = 'sakurako_atk1.mp3',                                   -- Throw Object
  [CHAR_SOUND_WHOA] = 'sakurako_ledge.mp3',                                  -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'sakurako_longjump.mp3' },                          -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'sakurako_atk1.mp3' },                  -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sakurako_jump1.mp3', 'sakurako_jump2.mp3' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_HANAE = {
  [CHAR_SOUND_ATTACKED] = { 'Hanae_ATTACKED1.ogg', 'Hanae_ATTACKED2.ogg' },
  [CHAR_SOUND_DOH] = 'Hanae_BONK.ogg',                                       -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Hanae_DYING.ogg' },
  [CHAR_SOUND_HAHA] = { 'Hanae_HAHA.ogg' },                                  -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Hanae_HEREWEGO.ogg', 'Hanae_HEREWEGO2.ogg' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'Hanae_HOOHOO.ogg' },                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                              -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = '',
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'Hanae_GROUND_POUND_WAH.ogg' },
  [CHAR_SOUND_LETS_A_GO] = { 'Hanae_LETSAGO.ogg' },                              -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'Hanae_MAMA_MIA.ogg' },                              -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'Hanae_OOOF2.ogg' },                                  -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Hanae_OOOF.ogg',                                          -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Hanae_OOOF2.ogg',                                        -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Hanae_PUNCH_HOO.ogg' },                            -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Hanae_PUNCH_WAH.ogg',                                -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Hanae_PUNCH_YAH.ogg',                                -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Hanae_SO_LONGA_BOWSER.ogg' },                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Hanae_TWIRL_BOUNCE.ogg' },                      -- Boing
  [CHAR_SOUND_UH] = 'Hanae_UH.ogg',                                              -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Hanae_UH.ogg' },                                         -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Hanae_WAAAOOOW.ogg',                                  -- Falling
  [CHAR_SOUND_WAH2] = { 'Hanae_WAH2.ogg' },                                      -- Throw Object
  [CHAR_SOUND_WHOA] = 'Hanae_WHOA.ogg',                                          -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Hanae_YAHOO.ogg' },                                    -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Hanae_TWIRL_BOUNCE.ogg' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Hanae_PUNCH_YAH.ogg', 'Hanae_YAH_WAH_HOO.ogg' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = {''},
}

VT_UI = {
  [CHAR_SOUND_ATTACKED] = { 'ui_dmg1.mp3', 'ui_dmg2.mp3', 'ui_dmg3.mp3' },
  [CHAR_SOUND_DOH] = 'ui_eh.mp3',    -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'ui_dying.mp3' },
  [CHAR_SOUND_HRMM] = 'ui_grab.mp3', -- Object Pick-up
  -- [CHAR_SOUND_EEUH] = {'mmr_slowclimb.mp3'}, -- Slow Get up from ledge
  [CHAR_SOUND_GROUND_POUND_WAH] = { 'ui_punch2.mp3' },
  [CHAR_SOUND_HAHA] = { 'ui_oh.mp3' },                                             -- Landing after backflip
  [CHAR_SOUND_HAHA_2] = 'ui_oh.mp3',                                               -- Landing on Water after a fall
  [CHAR_SOUND_HERE_WE_GO] = { 'ui_star.mp3' },                                     -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'ui_jump2.mp3' },                                        -- 2nd Jump + Dive Attack
  -- [CHAR_SOUND_IMA_TIRED] = 'ksm_sigh.mp3',
  [CHAR_SOUND_LETS_A_GO] = { 'ui_letsGo.mp3' },                                    -- Level Select
  [CHAR_SOUND_MAMA_MIA] = { 'ui_levelFail.mp3' },                                  -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'ui_groundPound.mp3' },                                 -- Touch Fire
  [CHAR_SOUND_OOOF] = 'ui_eh.mp3',                                                 -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'ui_dmg3.mp3',                                              -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'ui_kick.mp3' },                                      -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'ui_punch2.mp3',                                        -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'ui_punch1.mp3',                                        -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'ui_jump3.mp3' },                               -- Bowser Throw
  [CHAR_SOUND_UH] = 'ui_eh.mp3',                                                   -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'ui_jump1.mp3' },                                           -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'ui_dmg2.mp3',                                           -- Falling
  [CHAR_SOUND_WAH2] = { 'ui_punch1.mp3' },                                         -- Throw Object
  [CHAR_SOUND_WHOA] = 'ui_ledge.mp3',                                              -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'ui_yahoo.mp3' },                                         -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'ui_jump3.mp3' },                             -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'ui_punch1.mp3', 'ui_jump2.mp3', 'ui_punch2.mp3' }, -- 1st Jump(s)
  [CHAR_SOUND_YAWNING] = { 'ui_burn.mp3' },
}

VT_HINATA = {
  [CHAR_SOUND_ATTACKED] = { 'hinata_dmg1.ogg', 'hinata_surprised.ogg', 'hinata_wah3.ogg' }, --
  [CHAR_SOUND_DOH] = 'hinata_surprised2.ogg',                                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'hinata_dead1.ogg', 'hinata_dead2.ogg' },
  --[CHAR_SOUND_EEUH] = nil, -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'hinata_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'hinata_great.ogg', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil, -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'hinata_star1.ogg' },       -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'hinata_atk2.ogg',                -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',           -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = { 'hinata_tired.ogg' },
  [CHAR_SOUND_LETS_A_GO] = 'hinata_levelselect.ogg',      -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'hinata_levelexit.ogg',         -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'hinata_wah2.ogg' },           -- Touch Fire --
  [CHAR_SOUND_OOOF] = 'hinata_wah.ogg',
  [CHAR_SOUND_OOOF2] = 'hinata_dmg1.ogg',                 -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'hinata_atk3.ogg' },         -- Kick --
  [CHAR_SOUND_PUNCH_WAH] = 'hinata_atk1.ogg',             -- 2nd Punch --
  [CHAR_SOUND_PUNCH_YAH] = 'hinata_atk1.ogg',             -- 1st Punch --
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'hinata_bthrow.ogg' }, -- Bowser Throw --
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },   -- Boing
  [CHAR_SOUND_UH] = 'hinata_wah.ogg',                     -- Drop off of ledge
  [CHAR_SOUND_UH2] = { 'hinata_atk1.ogg' },               -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'hinata_fall.ogg',              -- Falling
  [CHAR_SOUND_WAH2] = 'sfx_ssb64_itemthrow.mp3',          -- Throw Object --
  [CHAR_SOUND_WHOA] = 'hinata_huh.ogg',                   -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'hinata_longjump.ogg' },         -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'hinata_atk3.ogg' }, -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'hinata_atk1.ogg' },       -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = nil,
}

VT_SHIMIKO = {
  [CHAR_SOUND_ATTACKED] = { 'Shimiko_ATTACKED.ogg' }, --
  [CHAR_SOUND_DOH] = 'Shimiko_OOOF2.ogg',             -- Bonk into walls
  --[CHAR_SOUND_DYING] = { 'hinata_dead1.ogg', 'hinata_dead2.ogg' },
  --[CHAR_SOUND_EEUH] = nil,                                                            -- Slow Get up from ledge
  --[CHAR_SOUND_GAME_OVER] = nil,
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'hinata_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'Shimiko_HAHA.ogg', -- Landing after backflip
  --[CHAR_SOUND_HAHA_2] = nil,                                                          -- Landing on Water after a fall
  --[CHAR_SOUND_HELLO] = nil,
  [CHAR_SOUND_HERE_WE_GO] = { 'Shimiko_HERE_WE_GO.ogg' },      -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'Shimiko_HOOHOO.ogg',                  -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = { 'Shimiko_YAWNING.ogg' },
  [CHAR_SOUND_LETS_A_GO] = 'Shimiko_LETS_A_GO.ogg',            -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = 'hinata_levelexit.ogg',                                     -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'Shimiko_OOOF2.ogg' },              -- Touch Fire --
  --[CHAR_SOUND_OOOF] = 'hinata_wah.ogg',
  [CHAR_SOUND_OOOF2] = 'Shimiko_ATTACKED.ogg',                 -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'Shimiko_PUNCH_HOO.ogg' },        -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Shimiko_YAH_WAH_HOO2.ogg',         -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Shimiko_YAH_WAH_HOO.ogg',          -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' }, -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },        -- Boing
  --[CHAR_SOUND_UH] = 'Shimiko_UH.ogg',                                                 -- Drop off of ledge
  --[CHAR_SOUND_UH2] = { 'hinata_atk1.ogg' },                                           -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'Shimiko_YAHOO.ogg',                          -- Falling
  [CHAR_SOUND_WAH2] = 'sfx_ssb64_itemthrow.mp3',                        -- Throw Object --
  [CHAR_SOUND_WHOA] = 'Shimiko_YAH_WAH_HOO.ogg',                        -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Shimiko_YAHOO.ogg' },                         -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Shimiko_YAHOO_WAHA_YIPPEE.ogg' }, -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Shimiko_YAH_WAH_HOO.ogg' },             -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = 'Shimiko_YAWNING.ogg',
}

VT_RABU = {
  [CHAR_SOUND_ATTACKED] = { 'rabu_dmg1.mp3', 'rabu_dmg3.mp3' }, --
  [CHAR_SOUND_DOH] = 'rabu_eh2.mp3',                                               -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'rabu_dead1.mp3', 'rabu_dead2.mp3' },
  --[CHAR_SOUND_EEUH] = nil,                                                            -- Slow Get up from ledge
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'hinata_jump3.mp3' },
  [CHAR_SOUND_HAHA] = 'rabu_laugh1.mp3',                                               -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'rabu_star3.mp3', 'rabu_star2.mp3', 'rabu_star1.mp3', },                               -- Star Get + Obtaining Power-up --
  [CHAR_SOUND_HOOHOO] = 'rabu_jump1.mp3',                                           -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'rabu_grab.mp3',                                         -- Object Pick-up
  [CHAR_SOUND_IMA_TIRED] = { 'rabu_tired.mp3' },
  [CHAR_SOUND_LETS_A_GO] = 'rabu_levelselect2.mp3',                                     -- Level Select
  [CHAR_SOUND_MAMA_MIA] = 'rabu_beatyouup.mp3',                                     -- Getting up after thrown out of level --
  [CHAR_SOUND_ON_FIRE] = { 'rabu_dmg4.mp3', 'rabu_dmg2.mp3' },                                       -- Touch Fire --
  [CHAR_SOUND_OOOF] = 'rabu_backoff.mp3',
  [CHAR_SOUND_OOOF2] = 'rabu_dmg3.mp3',                                          -- Landing After a Bonk + Thrown out of level --
  [CHAR_SOUND_PUNCH_HOO] = { 'rabu_atk1.mp3' },                                 -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'sfx_ssb64_atk2.mp3',                                  -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'sfx_ssb64_atk1.mp3',                                   -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'sfx_smrpg_fireball.mp3' },                          -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'sfx_smw_spring.mp3' },                                 -- Boing
  [CHAR_SOUND_UH] = 'rabu_eh3.mp3',                                                 -- Drop off of ledge
  --[CHAR_SOUND_UH2] = { 'hinata_atk1.ogg' },                                           -- Quick Ledge Get-Up
  --[CHAR_SOUND_UH2_2] = nil, -- Landing after Long Jump
  [CHAR_SOUND_WAAAOOOW] = 'rabu_dmg4.mp3',                                          -- Falling
  [CHAR_SOUND_WAH2] = 'rabu_throw.mp3',                                        -- Throw Object --
  [CHAR_SOUND_WHOA] = 'rabu_ara.mp3',                                        -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'rabu_totsugeki.mp3' },                                         -- Long Jump --
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'rabu_laugh1.mp3' },                 -- 3rd Jump(s) --
  [CHAR_SOUND_YAH_WAH_HOO] = { 'sfx_smw_jump.mp3' },                             -- 1st Jump(s) --
  --[CHAR_SOUND_YAWNING] = 'Shimiko_YAWNING.ogg',
}

VT_SERINA = {
  [CHAR_SOUND_ATTACKED] = { 'Serina_ATTACKED.ogg', },
  [CHAR_SOUND_DOH] = 'Serina_ATTACKED.ogg',                                       -- Bonk into walls
  [CHAR_SOUND_DYING] = { 'Serina_DYING.ogg' },
  [CHAR_SOUND_HAHA] = { 'Serina_HAHA.ogg' },                                  -- Landing after backflip
  [CHAR_SOUND_HERE_WE_GO] = { 'Serina_HEREWEGO.ogg', 'Serina_HEREWEGO2.ogg' }, -- Star Get + Obtaining Power-up
  [CHAR_SOUND_HOOHOO] = { 'Serina_HOOHOO.ogg' },                              -- 2nd Jump + Dive Attack
  [CHAR_SOUND_HRMM] = 'sfx_ssb64_itemgrab.mp3',                              -- Object Pick-up
  --[CHAR_SOUND_IMA_TIRED] = '',
  --[CHAR_SOUND_GROUND_POUND_WAH] = { 'Hanae_GROUND_POUND_WAH.ogg' },
  [CHAR_SOUND_LETS_A_GO] = { 'Serina_LETSAGO.ogg' },                              -- Level Select
  --[CHAR_SOUND_MAMA_MIA] = { 'Hanae_MAMA_MIA.ogg' },                              -- Getting up after thrown out of level
  [CHAR_SOUND_ON_FIRE] = { 'Serina_ONFIRE.ogg' },                                  -- Touch Fire
  [CHAR_SOUND_OOOF] = 'Serina_OOOF2.ogg',                                          -- Grabbed by Chuckya
  [CHAR_SOUND_OOOF2] = 'Serina_OOOF2.ogg',                                        -- Landing After a Bonk + Thrown out of level + Also bonk into walls?
  [CHAR_SOUND_PUNCH_HOO] = { 'Serina_YAHOO.ogg' },                            -- Kick
  [CHAR_SOUND_PUNCH_WAH] = 'Serina_YAH_WAH_HOO2.ogg',                                -- 2nd Punch
  [CHAR_SOUND_PUNCH_YAH] = 'Serina_YAH_WAH_HOO1.ogg',                                -- 1st Punch
  [CHAR_SOUND_SO_LONGA_BOWSER] = { 'Serina_WAH2.ogg' },                -- Bowser Throw
  [CHAR_SOUND_TWIRL_BOUNCE] = { 'Serina_YAHOO_WAHA_YIPPEE.ogg' },                      -- Boing
  [CHAR_SOUND_UH] = 'Serina_UH.ogg',                                              -- Drop off of ledge + Fall off Ledge
  [CHAR_SOUND_UH2] = { 'Serina_UH.ogg' },                                         -- Quick Ledge Get-Up
  [CHAR_SOUND_WAAAOOOW] = 'Serina_WAAAOOOW.ogg',                                  -- Falling
  [CHAR_SOUND_WAH2] = { 'Serina_WAH2.ogg' },                                      -- Throw Object
  [CHAR_SOUND_WHOA] = 'Serina_WHOA.ogg',                                          -- Ledge Grab
  [CHAR_SOUND_YAHOO] = { 'Serina_YAHOO.ogg' },                                    -- Long Jump
  [CHAR_SOUND_YAHOO_WAHA_YIPPEE] = { 'Serina_YAHOO_WAHA_YIPPEE.ogg' },                 -- 3rd Jump(s)
  [CHAR_SOUND_YAH_WAH_HOO] = { 'Serina_YAH_WAH_HOO1.ogg', 'Serina_YAH_WAH_HOO2.ogg' }, -- 1st Jump(s)
  --[CHAR_SOUND_YAWNING] = {''},
}
-- ================
-- Trinity End
-- ================
